/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.security.utils;

import com.ruoyi.common.core.context.SecurityContextHolder;
import com.ruoyi.common.core.utils.ServletUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.system.api.model.LoginUser;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SecurityUtils {
    public static Long getUserId() {
        return SecurityContextHolder.getUserId();
    }

    public static String getUsername() {
        return SecurityContextHolder.getUserName();
    }

    public static String getUserKey() {
        return SecurityContextHolder.getUserKey();
    }

    public static LoginUser getLoginUser() {
        return (LoginUser)SecurityContextHolder.get((String)"login_user", LoginUser.class);
    }

    public static String getToken() {
        return SecurityUtils.getToken(ServletUtils.getRequest());
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        return SecurityUtils.replaceTokenPrefix(token);
    }

    public static String replaceTokenPrefix(String token) {
        if (StringUtils.isNotEmpty((String)token) && token.startsWith("Bearer ")) {
            token = token.replaceFirst("Bearer ", "");
        }
        return token;
    }

    public static boolean isAdmin(Long userId) {
        return userId != null && 1L == userId;
    }

    public static String encryptPassword(String password) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.encode((CharSequence)password);
    }

    public static boolean matchesPassword(String rawPassword, String encodedPassword) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.matches((CharSequence)rawPassword, encodedPassword);
    }
}

