/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.security.service;

import com.ruoyi.common.core.utils.JwtUtils;
import com.ruoyi.common.core.utils.ServletUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.utils.ip.IpUtils;
import com.ruoyi.common.core.utils.uuid.IdUtils;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.model.LoginUser;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenService {
    private static final Logger log = LoggerFactory.getLogger(TokenService.class);
    @Autowired
    private RedisService redisService;
    protected static final long MILLIS_SECOND = 1000L;
    protected static final long MILLIS_MINUTE = 60000L;
    private static final long TOKEN_EXPIRE_TIME = 720L;
    private static final String ACCESS_TOKEN = "login_tokens:";
    private static final Long TOKEN_REFRESH_THRESHOLD_MINUTES = 0x6DDD00L;

    public Map<String, Object> createToken(LoginUser loginUser) {
        String token = IdUtils.fastUUID();
        Long userId = loginUser.getSysUser().getUserId();
        String userName = loginUser.getSysUser().getUserName();
        loginUser.setToken(token);
        loginUser.setUserid(userId);
        loginUser.setUsername(userName);
        loginUser.setIpaddr(IpUtils.getIpAddr());
        this.refreshToken(loginUser);
        HashMap<String, Object> claimsMap = new HashMap<String, Object>();
        claimsMap.put("user_key", token);
        claimsMap.put("user_id", userId);
        claimsMap.put("username", userName);
        HashMap<String, Object> rspMap = new HashMap<String, Object>();
        rspMap.put("access_token", JwtUtils.createToken(claimsMap));
        rspMap.put("expires_in", 720L);
        return rspMap;
    }

    public LoginUser getLoginUser() {
        return this.getLoginUser(ServletUtils.getRequest());
    }

    public LoginUser getLoginUser(HttpServletRequest request) {
        String token = SecurityUtils.getToken(request);
        return this.getLoginUser(token);
    }

    public LoginUser getLoginUser(String token) {
        LoginUser user = null;
        try {
            if (StringUtils.isNotEmpty((String)token)) {
                String userkey = JwtUtils.getUserKey((String)token);
                user = (LoginUser)this.redisService.getCacheObject(this.getTokenKey(userkey));
                return user;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38'{}'", (Object)e.getMessage());
        }
        return user;
    }

    public void setLoginUser(LoginUser loginUser) {
        if (StringUtils.isNotNull((Object)loginUser) && StringUtils.isNotEmpty((String)loginUser.getToken())) {
            this.refreshToken(loginUser);
        }
    }

    public void delLoginUser(String token) {
        if (StringUtils.isNotEmpty((String)token)) {
            String userkey = JwtUtils.getUserKey((String)token);
            this.redisService.deleteObject(this.getTokenKey(userkey));
        }
    }

    public void verifyToken(LoginUser loginUser) {
        long currentTime;
        long expireTime = loginUser.getExpireTime();
        if (expireTime - (currentTime = System.currentTimeMillis()) <= TOKEN_REFRESH_THRESHOLD_MINUTES) {
            this.refreshToken(loginUser);
        }
    }

    public void refreshToken(LoginUser loginUser) {
        loginUser.setLoginTime(Long.valueOf(System.currentTimeMillis()));
        loginUser.setExpireTime(Long.valueOf(loginUser.getLoginTime() + 43200000L));
        String userKey = this.getTokenKey(loginUser.getToken());
        this.redisService.setCacheObject(userKey, (Object)loginUser, Long.valueOf(720L), TimeUnit.MINUTES);
    }

    private String getTokenKey(String token) {
        return ACCESS_TOKEN + token;
    }
}

