/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.security.feign;

import com.ruoyi.common.core.utils.ServletUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.utils.ip.IpUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FeignRequestInterceptor
implements RequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        if (StringUtils.isNotNull((Object)httpServletRequest)) {
            String authentication;
            String userName;
            String userKey;
            Map headers = ServletUtils.getHeaders((HttpServletRequest)httpServletRequest);
            String userId = (String)headers.get("user_id");
            if (StringUtils.isNotEmpty((String)userId)) {
                requestTemplate.header("user_id", new String[]{userId});
            }
            if (StringUtils.isNotEmpty((String)(userKey = (String)headers.get("user_key")))) {
                requestTemplate.header("user_key", new String[]{userKey});
            }
            if (StringUtils.isNotEmpty((String)(userName = (String)headers.get("username")))) {
                requestTemplate.header("username", new String[]{userName});
            }
            if (StringUtils.isNotEmpty((String)(authentication = (String)headers.get("Authorization")))) {
                requestTemplate.header("Authorization", new String[]{authentication});
            }
            requestTemplate.header("X-Forwarded-For", new String[]{IpUtils.getIpAddr()});
        }
    }
}

